<?php
// === Konfigurasi ===
$botToken = "8449252581:AAE-mplDQPCKIlbD6iCzL4ZwY7zcgKkcJwU"; // ganti token bot kamu
$adminChatId = "8250132778"; // ganti chat_id admin kamu
$dataPath = __DIR__ . "/data/chats/";

// Pastikan folder data/chats ada
if (!is_dir($dataPath)) mkdir($dataPath, 0777, true);

// === Ambil data dari Telegram ===
$update = json_decode(file_get_contents("php://input"), true);
if (!$update) exit("No data");

// Simpan log untuk debugging
file_put_contents(__DIR__ . "/data/log.txt", date('Y-m-d H:i:s') . " => " . json_encode($update, JSON_PRETTY_PRINT) . "\n", FILE_APPEND);

if (isset($update['message'])) {
    $msg = $update['message'];
    $chatId = $msg['chat']['id'];
    $text = trim($msg['text'] ?? '');

    // Jika pesan dari website (user)
    if ($chatId != $adminChatId && isset($msg['text'])) {
        $sid = "sess_" . substr(md5($chatId), 0, 8);
        $file = $dataPath . "$sid.json";

        $messages = file_exists($file) ? json_decode(file_get_contents($file), true) : [];
        $messages[] = ["from" => "user", "message" => $text];
        file_put_contents($file, json_encode($messages, JSON_PRETTY_PRINT));

        // Kirim ke admin
        $txt = "🧍 Pesan baru dari user\n💬 $text\nSession: $sid";
        file_get_contents("https://api.telegram.org/bot$botToken/sendMessage?chat_id=$adminChatId&text=" . urlencode($txt));
    }

    // Jika admin membalas pesan user
    if ($chatId == $adminChatId && isset($msg['reply_to_message'])) {
        $replyText = $msg['reply_to_message']['text'] ?? '';
        $adminReply = $msg['text'] ?? '';

        // Deteksi Session dari pesan yang dibalas
        if (preg_match('/Session:\s*(sess_[a-z0-9]+)/i', $replyText, $m)) {
            $sid = $m[1];
            $file = $dataPath . "$sid.json";

            if (file_exists($file)) {
                $messages = json_decode(file_get_contents($file), true);
                $messages[] = ["from" => "admin", "message" => $adminReply];
                file_put_contents($file, json_encode($messages, JSON_PRETTY_PRINT));
            } else {
                file_put_contents($dataPath . "debug.txt", "Gagal menemukan file untuk session $sid\n", FILE_APPEND);
            }
        } else {
            file_put_contents($dataPath . "debug.txt", "Session tidak ditemukan di reply message\n", FILE_APPEND);
        }
    }
}

echo "OK";
?>
