(() => {
  // ====== STYLE ======
  const style = document.createElement("style");
  style.textContent = `
  #chat-toggle {
    position: fixed;
    bottom: 20px;
    right: 20px;
    background: #0088cc;
    color: white;
    border: none;
    border-radius: 50%;
    width: 55px;
    height: 55px;
    font-size: 26px;
    cursor: pointer;
    z-index: 9999;
    box-shadow: 0 3px 10px rgba(0,0,0,0.3);
  }

  #chat-box {
    position: fixed;
    bottom: 85px;
    right: 20px;
    width: 320px;
    background: #fff;
    border-radius: 12px;
    box-shadow: 0 0 15px rgba(0,0,0,0.25);
    display: none;
    flex-direction: column;
    overflow: hidden;
    font-family: 'Segoe UI', sans-serif;
    z-index: 9998;
  }

  #chat-header {
    background: #0088cc;
    color: white;
    padding: 12px;
    font-weight: bold;
    display: flex;
    align-items: center;
    gap: 10px;
    position: relative;
  }

  #chat-header img {
    width: 35px;
    height: 35px;
    border-radius: 50%;
    border: 2px solid #fff;
    object-fit: cover;
  }

  #status-dot {
    position: absolute;
    left: 38px;
    bottom: 10px;
    width: 10px;
    height: 10px;
    background: #00ff66;
    border-radius: 50%;
    border: 2px solid #fff;
  }

  #chat-body {
    padding: 10px;
    flex-grow: 1;
    max-height: 250px;
    overflow-y: auto;
    display: flex;
    flex-direction: column;
    background: #f9f9f9;
  }

  .msg {
    margin: 5px 0;
    padding: 7px 10px;
    border-radius: 10px;
    max-width: 80%;
    word-wrap: break-word;
  }
  .user {
    background: #dcf8c6;
    color: #000;
    align-self: flex-end;
    border-radius: 15px 15px 0 15px;
  }
  .admin {
    background: #0088cc;
    color: #fff;
    align-self: flex-start;
    border-radius: 15px 15px 15px 0;
  }

  #chat-footer {
    display: none;
    gap: 5px;
    padding: 8px;
    background: #fff;
    border-top: 1px solid #eee;
  }

  #chat-footer textarea {
    flex: 1;
    padding: 8px;
    border-radius: 6px;
    border: 1px solid #ddd;
    font-size: 14px;
    resize: none;
  }

  #chat-send {
    background: #0088cc; 
    color: white; 
    border: none;
    padding: 8px 12px; 
    border-radius: 6px; 
    cursor: pointer;
  }

  #user-info {
    display: flex;
    flex-direction: column;
    padding: 15px;
    gap: 10px;
    text-align: center;
  }

  #user-info input {
    padding: 8px;
    border-radius: 6px;
    border: 1px solid #ccc;
    font-size: 14px;
  }

  #start-chat {
    background: #0088cc;
    color: white;
    border: none;
    padding: 8px;
    border-radius: 6px;
    cursor: pointer;
  }
  `;
  document.head.appendChild(style);

  // ====== ELEMENT ======
  const wrapper = document.createElement("div");
  wrapper.innerHTML = `
    <button id="chat-toggle">&#128172;</button>
    <div id="chat-box">
      <div id="chat-header">
        <img src="/livechat/ft.jpg" alt="Agent">
        <span id="status-dot"></span>
        <div>
          <div>Agen Live Chat</div>
          <small style="font-size:12px;opacity:0.9;">Online sekarang</small>
        </div>
      </div>

      <div id="chat-body">
        <div id="user-info">
          <h4>Masukkan Data Anda</h4>
          <input id="chat-name" placeholder="Nama Anda" />
          <input id="chat-email" placeholder="Email Anda" />
          <button id="start-chat">Mulai Chat</button>
        </div>
      </div>

      <div id="chat-footer">
        <textarea id="chat-message" placeholder="Ketik pesan..." rows="1"></textarea>
        <button id="chat-send">&#10148;</button>
      </div>
    </div>
  `;
  document.body.appendChild(wrapper);

  // ====== VARIABEL ======
  const toggle = document.getElementById("chat-toggle");
  const box = document.getElementById("chat-box");
  const body = document.getElementById("chat-body");
  const footer = document.getElementById("chat-footer");
  const sendBtn = document.getElementById("chat-send");
  const msgInput = document.getElementById("chat-message");
  const startBtn = document.getElementById("start-chat");
  const userInfo = document.getElementById("user-info");
  const nameInput = document.getElementById("chat-name");
  const emailInput = document.getElementById("chat-email");
  const statusDot = document.getElementById("status-dot");

  const sound = new Audio("https://cdn.pixabay.com/audio/2022/03/15/audio_3f3db5d24b.mp3");

  let userName = localStorage.getItem("chat_name");
  let userEmail = localStorage.getItem("chat_email");
  let lastMessages = [];

  // ====== TOGGLE WIDGET ======
  toggle.onclick = () => {
    box.style.display = box.style.display === "flex" ? "none" : "flex";
  };

  // ====== START CHAT ======
  startBtn.onclick = () => {
    const name = nameInput.value.trim();
    const email = emailInput.value.trim();

    if (!name || !email) {
      alert("Harap isi nama dan email terlebih dahulu.");
      return;
    }

    userName = name;
    userEmail = email;
    localStorage.setItem("chat_name", name);
    localStorage.setItem("chat_email", email);

    userInfo.style.display = "none";
    footer.style.display = "flex";

    appendMessage("admin", `Halo ${name}, ada yang bisa kami bantu hari ini?`);
  };

  // ====== KIRIM PESAN ======
  sendBtn.onclick = sendMessage;
  msgInput.addEventListener("keypress", e => {
    if (e.key === "Enter" && !e.shiftKey) {
      e.preventDefault();
      sendMessage();
    }
  });

  function appendMessage(from, text) {
    const msg = document.createElement("div");
    msg.className = "msg " + from;
    msg.textContent = text;
    body.appendChild(msg);
    body.scrollTop = body.scrollHeight;
  }

  async function sendMessage() {
    const msg = msgInput.value.trim();
    if (!msg) return;

    appendMessage("user", msg);
    msgInput.value = "";

    await fetch("/livechat/sendToTelegram.php", {
      method: "POST",
      headers: {"Content-Type": "application/json"},
      body: JSON.stringify({
        name: userName,
        email: userEmail,
        message: msg
      })
    });
  }

  // ====== LOAD PESAN BARU DARI SERVER ======
  async function checkMessages() {
    try {
      const res = await fetch("/livechat/messages.json?cache=" + Date.now());
      if (!res.ok) return;
      const data = await res.json();

      if (Array.isArray(data) && JSON.stringify(data) !== JSON.stringify(lastMessages)) {
        const newMessages = data.filter(m => !lastMessages.includes(m));
        newMessages.forEach(m => {
          if (m.sender === "admin") {
            appendMessage("admin", m.text);
            sound.play();
          }
        });
        lastMessages = data;
      }

      // Admin status (online/offline)
      statusDot.style.background = data.some(m => m.sender === "admin") ? "#00ff66" : "#aaa";

    } catch (err) {
      console.error("Gagal cek pesan:", err);
    }
  }

  // Jalankan auto-refresh setiap 4 detik
  setInterval(checkMessages, 4000);

  // ====== CEK DATA USER SAAT LOAD ======
  if (userName && userEmail) {
    userInfo.style.display = "none";
    footer.style.display = "flex";
  } else {
    userInfo.style.display = "flex";
    footer.style.display = "none";
  }
})();
